/*==========================================================================
  GPBLIT.C

  Example code to perform a general pattern blit.

  Copyright (c) 1994-1995 ATI Technologies Inc. All rights reserved
 =========================================================================*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <conio.h>
#include <dos.h>
#include "..\util\atim64.h"
#include "..\util\sample.h"

#define INSTANCE 0

int main (int argc, char *argv[])
{
    int srcx, srcy, dstx, dsty, srcwidth, srcheight, dstwidth, dstheight;
    unsigned long rotation;

    // check if Mach64 adapter is installed
    if (detect_mach64 (INSTANCE) != YES_MACH64)
    {
        printf ("mach64 based adapter was not found.\n");
        return (1);
    }

    // fill global query structure by calling Mach 64 ROM
    if (query_hardware () != NO_ERROR)
    {
        printf ("Failed ROM call to query Mach64 hardware.\n");
        return (1);
    }

    // Process the command line arguments to override default resolution
    // and color depth settings.
    process_command_line (argc, argv);

    // set an accelerator mode
    if (open_mode (gmode_res, PITCH_XRES, gclr_depth) != NO_ERROR)
    {
        printf ("Error in setting display mode.\n");
        return (1);
    }

    // initialize standard engine context
    init_engine ();
    clear_screen (0, 0, modeinfo.xres, modeinfo.yres);

    // Setup dimensions of source and destination
    srcx = modeinfo.xres / 64;         // source
    srcy = modeinfo.yres / 48;
    srcwidth = modeinfo.xres / 16;
    srcheight = modeinfo.yres / 12;

    dstx = modeinfo.xres / 8;          // destination
    dsty = modeinfo.yres / 16;
    dstwidth = modeinfo.xres / 4;
    dstheight = modeinfo.yres / 3;

    // Draw some filled rectangles to act as a source:
    //
    set_fg_color (get_color_code (WHITE));
    draw_rectangle (srcx, srcy, srcwidth, srcheight);

    set_fg_color (get_color_code (LIGHTBLUE));
    draw_rectangle (srcx + 4, srcy + 4, srcwidth - 8, srcheight - 8);

    // Draw a general pattern blit:
    //
    //    The source data is at (srcx, srcy) and has a size of
    //    (srcwidth, srcheight). The destination blit will be drawn at
    //    (dstx, dsty) with a size of (dstwidth, dstheight). The general
    //    pattern blit allows the source to wrap in the X & Y directions
    //    while continuing to draw to the destination.
    //

    // Setup for color blit:
    //
    //    The monochrome path controls which source channel is used to read
    //    the source data. If the monochrome path is "1", the foreground
    //    channel is selected as the source; if the monochrome path is "0",
    //    the background channel is selected. In this case, the monochrome
    //    path will be set to "1".
    //
    wait_for_fifo (11);
    regw (DP_SRC, MONO_SRC_ONE | FRGD_SRC_BLIT);

    // Use general pattern for source:
    //
    //    This implies that the destination rectangle can be a different
    //    size than the source rectangle - in this example, the destination
    //    rectangle is larger.
    //
    regw (SRC_CNTL, SRC_PATTERN_ENABLE);

    // set source start coordinate and rectangle size

    // Adjust source trajectory starting x value and width for 24 bpp mode.
    if (modeinfo.bpp == 24)
    {
        srcx = srcx * 3;
        srcwidth = srcwidth * 3;
    }
    regw (SRC_X, srcx);
    regw (SRC_Y, srcy);
    regw (SRC_HEIGHT1, srcheight);
    regw (SRC_WIDTH1, srcwidth);

    // set draw direction bits and adjust for 24 bpp mode if required
    if (modeinfo.bpp == 24)
    {
        // Get the dstx parameter 24bpp rotation before adjusting it.
        rotation = GET24BPPROTATION (dstx);

        // adjust horizontal parameters for 24 bpp
        dstx = dstx * 3;
        dstwidth = dstwidth * 3;

        // setup 24 bpp alignment
        regw (DST_CNTL, DST_24_ROTATION_ENABLE |
                        DST_Y_TOP_TO_BOTTOM |
                        DST_X_LEFT_TO_RIGHT |
                        (rotation << 8));
    }
    else
    {
        regw (DST_CNTL, DST_Y_TOP_TO_BOTTOM | DST_X_LEFT_TO_RIGHT);
    }

    // set destination start coordinate and rectangle size
    regw (DST_X, dstx);
    regw (DST_Y, dsty);
    regw (DST_HEIGHT, dstheight);
    regw (DST_WIDTH, dstwidth);         // this write initiates the operation

    // wait for a carriage return
    getch ();

    // disable accelerator mode and switch back to VGA text mode
    close_mode ();

    return (0);
}

