; ===========================================================================
; ROMCAL13.ASM
;
; Mach64 ROM interface function 13h - Display Data Channel (DDC) support.
;
; Compiling:
;   masm /Ml /D<memory model> romcalls.asm;
;       <memory model> = mem_S for SMALL model,
;                        mem_M for MEDIUM model,
;                        mem_L for LARGE model
;
; Copyright (c) 1993-94 ATI Technologies Inc. All rights reserved
; ===========================================================================

include ..\inc\atim64.inc

IFDEF mem_S
PARM        equ     4   ; passed parameters start at bp+4 for small model
ELSE
PARM        equ     6   ; passed parameters start at bp+6 for other models
ENDIF

IFDEF mem_S
.MODEL  SMALL, C
ELSEIFDEF mem_M
.MODEL  MEDIUM, C
ELSE
.MODEL  LARGE, C
ENDIF

.DATA

rom_addr    dw      64h
            dw      0c000h
            db      0

.CODE
.286

; Macro for 'call' model handling
Mcall       macro   routine
IFDEF mem_S
            call    NEAR PTR routine
ELSE
            call    FAR PTR routine
ENDIF
	        endm

; Externals
IFDEF mem_S
extrn   pgl_getrombase:NEAR
ELSE
extrn   pgl_getrombase:FAR
ENDIF

; ---------------------------------------------------------------------------
; ROM_DDCQUERY - ROM function 13h, sub-function 00h
;
; Query DDC support of the currently attached monitor. Input parameters are
; fetched from the stack. See PGL.H for symbolic values. This function can
; only be used in VGA mode.
;
; Inputs : DWORD PTR to ROM support
;            bit 0 = 1  - DDC1 supported by ROM
;            bit 1 = 1  - DDC2B supported by ROM
;            bit 6 = 1  - detailed EDID timing supported at powerup
;            bit 7 = 1  - ROM can use EDID info to setup card at powerup
;
;          DWORD PTR to monitor support
;            all bits 0 - DDC not supported
;            bit 0 = 1  - DDC1 supported by monitor
;            bit 1 = 1  - DDC2B supported by monitor
;
; Outputs: Return codes
;            0 - no error
;            1 - function complete with error
;            2 - function not supported
; ---------------------------------------------------------------------------
            public  ROM_DDCquery

IFDEF mem_S
ROM_DDCquery proc near
ELSE
ROM_DDCquery proc far
ENDIF
            ; create frame pointer
            push    bp
            mov     bp, sp

            ; save registers used
            push    bx
            push    di
            push    es

            ; setup parameters for call to ATI rom
            Mcall   pgl_getrombase              ; get rom segment in ax
            mov     rom_addr+2, ax
            mov     bx, 0                       ; sub-function 00h
            mov     ax, 13h                     ; function code 13h
            mov     rom_addr, 64h
            call    DWORD PTR rom_addr          ; call ROM using FAR CALL

            ; setup DDC ROM support result
            push    ax
            mov     di, WORD PTR [bp+PARM]      ; get pointer offset
            mov     ax, WORD PTR [bp+PARM+2]    ; get pointer segment
            mov     es, ax
            pop     ax
            push    ax
            xor     ah, ah
            mov     es:[di], ax
            pop     ax

            ; setup DDC monitor support result
            push    ax
            mov     di, WORD PTR [bp+PARM+4]    ; get pointer offset
            mov     ax, WORD PTR [bp+PARM+6]    ; get pointer segment
            mov     es, ax
            pop     ax
            mov     es:[di], bx

            ; setup error code in AL
            mov     al, ah
            xor     ah, ah

            ; restore saved registers
            pop     es
            pop     di
            pop     bx

            ; remove frame pointer
            mov     sp, bp
            pop     bp

            ret

ROM_DDCquery endp

; ---------------------------------------------------------------------------
; ROM_DDCREADEDID - ROM function 13h, sub-function 01h
;
; Read DDC EDID packet from monitor (DDC1/DDC2B only). Input parameters are
; fetched from the stack. See PGL.H for symbolic values. This function can
; only be used in VGA mode.
;
; Inputs : WORD buffer size (the standard is 128 bytes)
;          DWORD PTR to EDID packet storage buffer
;
; Outputs: Return codes
;            0 - no error
;            1 - function complete with error
;            2 - function not supported
; ---------------------------------------------------------------------------
            public  ROM_DDCreadEDID

IFDEF mem_S
ROM_DDCreadEDID proc near
ELSE
ROM_DDCreadEDID proc far
ENDIF
            ; create frame pointer
            push    bp
            mov     bp, sp

            ; save registers used
            push    bx
            push    cx
            push    dx
            push    di

            ; setup parameters for call to ATI rom
            Mcall   pgl_getrombase              ; get rom segment in ax
            mov     rom_addr+2, ax
            mov     bx, 1                       ; sub-function 01h
            mov     cx, WORD PTR [bp+PARM]      ; get buffer size
            mov     di, WORD PTR [bp+PARM+2]    ; get buffer offset
            mov     dx, WORD PTR [bp+PARM+4]    ; get buffer segment
            mov     ax, 13h                     ; function code 13h
            mov     rom_addr, 64h
            call    DWORD PTR rom_addr          ; call ROM using FAR CALL

            ; setup error code in AL
            mov     al, ah
            xor     ah, ah

            ; restore saved registers
            pop     di
            pop     dx
            pop     cx
            pop     bx

            ; remove frame pointer
            mov     sp, bp
            pop     bp

            ret

ROM_DDCreadEDID endp

            end

