/*==========================================================================
 VTGA.H

 Header for VTGA.C file.

 Copyright (c) 1993-1995 ATI Technologies Inc. All rights reserved
 =========================================================================*/

/* Return codes for targa routines */
#define SUCCESS             0
#define OPEN_ERROR          1
#define MEMORY_ERROR        2
#define IMAGE_TYPE_ERROR    3

/* Use BYTE alignment */
#pragma pack(1)

typedef struct
{
    char id_length;     // file id length (follows header, if applicable)
    char cm_type;       // 0 = no color map, 1 = color map
    char image_type;    // 1 = uncompressed, color map
    int  cm_origin;     // starting color map index
    int  cm_length;     // number of color map entries
    char cm_entrysize;  // bits/color map entry
    int  x_origin;      // starting x position
    int  y_origin;      // starting y position
    int  width;         // image width in pixels
    int  height;        // image height in pixels
    char pixel_depth;   // image bits per pixel (8, 16, 24)
    char image_coord;   // image start coordinates
                                // 0 - bottom left
                                // 1 - bottom right
                                // 2 - top left
                                // 3 - top right
} TARGA_HEADER;

/* Restore to WORD alignment */
#pragma pack()


/* Routines in VTGA.C */

int get_targa_header (char *filename, TARGA_HEADER *header);
int set_targa_palette (char *filename);
int load_targa (char *filename, int x, int y);

