; ===========================================================================
; FNTADDR.ASM
;
; Interface routine to get font address from VGA ROM
;
; Compiling:
;   masm /Ml /D<memory model> getio.asm;
;       <memory model> = mem_S for SMALL model,
;                        mem_M for MEDIUM model,
;                        mem_L for LARGE model
;
; Copyright (c) 1994 ATI Technologies Inc. All rights reserved
; ===========================================================================

include ..\inc\atim64.inc

IFDEF mem_S
PARM        equ     4   ; passed parameters start at bp+4 for small model
ELSE
PARM        equ     6   ; passed parameters start at bp+6 for other models
ENDIF

IFDEF mem_S
.MODEL  SMALL, C
ELSEIFDEF mem_M
.MODEL  MEDIUM, C
ELSE
.MODEL  LARGE, C
ENDIF

.CODE
.286

; Macro for 'call' model handling
Mcall       macro   routine
IFDEF mem_S
            call    NEAR PTR routine
ELSE
            call    FAR PTR routine
ENDIF
	        endm

; ---------------------------------------------------------------------------
; PGL_GETFONTADDRESS
;
; Get VGA font address
;
; Inputs : WORD romcode (2 = 8x14, 3 = 8x8, 6 = 8x16)
;
; Outputs: DWORD PTR to font address
; ---------------------------------------------------------------------------
            public  pgl_getfontaddress

IFDEF mem_S
pgl_getfontaddress proc near
ELSE
pgl_getfontaddress proc far
ENDIF
            ; create frame pointer
            push    bp
            mov     bp, sp

            ; save registers used
            push    bx
            push    cx
            push    es

            ; call ROM to get font address
            mov     ax, WORD PTR [bp+PARM]      ; get rom code for font size
            mov     bh, al
            mov     ax, 1130h
            push    bp
            int     10h
            mov     ax, bp                      ; ES:BP = font pointer
            pop     bp
            mov     dx, es

            ; restore saved registers
            pop     es
            pop     cx
            pop     bx

            ; remove frame pointer
            mov     sp, bp
            pop     bp

            ret

pgl_getfontaddress endp

            end

